/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.entity.PeacockEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class PeacockModel
extends AdvancedEntityModel<PeacockEntity> {
    private final ModelPart Body;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;
    private final ModelPart LeftWing;
    private final ModelPart RightWing;
    private final ModelPart Head;
    private final ModelPart Tail1;
    private final ModelPart Tail2;
    private final ModelPart Tail3;
    private final ModelPart Tail4;
    private final ModelPart Tail5;
    private final ModelPart Tail6;
    private final ModelPart Tail7;

    public PeacockModel(ModelPart root) {
        this.Body = root.m_171324_("body");
        this.Head = this.Body.m_171324_("neck");
        this.LeftLeg = this.Body.m_171324_("legLeft");
        this.RightLeg = this.Body.m_171324_("legRight");
        this.LeftWing = this.Body.m_171324_("wingLeft");
        this.RightWing = this.Body.m_171324_("wingRight");
        ModelPart tail = this.Body.m_171324_("tail");
        this.Tail1 = tail.m_171324_("tail1");
        this.Tail2 = tail.m_171324_("tail2");
        this.Tail3 = tail.m_171324_("tail3");
        this.Tail4 = tail.m_171324_("tail4");
        this.Tail5 = tail.m_171324_("tail5");
        this.Tail6 = tail.m_171324_("tail6");
        this.Tail7 = tail.m_171324_("tail7");
    }

    public void setupAnim(PeacockEntity peacock, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.LeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.0f * limbSwingAmount;
        this.RightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.0f * limbSwingAmount;
        this.LeftWing.f_104204_ = 0.0f;
        this.RightWing.f_104204_ = 0.0f;
        this.setRotationAngle(this.Tail1, -0.436332f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail2, -0.436332f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail3, -0.436332f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail4, -0.436332f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail5, -0.436332f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail6, -0.436332f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail7, -0.436332f, 0.0f, 0.0f);
        if (peacock.isInPanic()) {
            this.LeftWing.f_104204_ = -0.436332f - Mth.m_14089_((float)ageInTicks) * 0.5f;
            this.RightWing.f_104204_ = 0.436332f + Mth.m_14089_((float)ageInTicks) * 0.5f;
        }
        if (peacock.isDestroyingCrops()) {
            this.Head.f_104204_ = 0.0f;
            this.Head.f_104203_ = 1.74533f + Mth.m_14089_((float)ageInTicks) * 0.5f;
            this.LeftWing.f_104204_ = -0.436332f - Mth.m_14089_((float)ageInTicks) * 0.25f;
            this.RightWing.f_104204_ = 0.436332f + Mth.m_14089_((float)ageInTicks) * 0.25f;
        } else {
            this.defaultHeadMovement(this.Head, 0.0f, 0.0f, headPitch, netHeadYaw);
        }
        if (peacock.isTailFluffed()) {
            this.setRotationAngle(this.Tail1, 1.48353f, 0.0f, 0.0f);
            this.setRotationAngle(this.Tail2, 1.481785f, 0.0f, 0.436332f);
            this.setRotationAngle(this.Tail3, 1.481785f, 0.0f, -0.436332f);
            this.setRotationAngle(this.Tail4, 1.480039f, 0.0f, 0.872665f);
            this.setRotationAngle(this.Tail5, 1.480039f, 0.0f, -0.872665f);
            this.setRotationAngle(this.Tail6, 1.478294f, 0.0f, 1.309f);
            this.setRotationAngle(this.Tail7, 1.478294f, 0.0f, -1.309f);
        }
    }

    public void prepareMobModel(PeacockEntity peacock, float limbSwing, float limbSwingAmount, float partialTick) {
        boolean isChild = peacock.m_6162_();
        this.Tail1.f_104207_ = !isChild;
        this.Tail2.f_104207_ = !isChild;
        this.Tail3.f_104207_ = !isChild;
        this.Tail4.f_104207_ = !isChild;
        this.Tail5.f_104207_ = !isChild;
        this.Tail6.f_104207_ = !isChild;
        this.Tail7.f_104207_ = !isChild;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_85837_(0.0, 1.5, 0.0);
        }
        this.Body.m_104301_(poseStack, bufferIn, packedLightIn, packedOverlayIn);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.5f, -3.5f, -5.0f, 7.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.5f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(20, 17).m_171488_(-1.5f, -9.0f, -2.0f, 3.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)-4.0f));
        PartDefinition crest = neck.m_171599_("crest", CubeListBuilder.m_171558_().m_171514_(1, 3).m_171488_(0.0f, -3.0f, -1.5f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.5f));
        PartDefinition beak = neck.m_171599_("beak", CubeListBuilder.m_171558_().m_171514_(1, 1).m_171488_(-0.5f, -1.0f, -2.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)-2.0f));
        PartDefinition legLeft = body.m_171599_("legLeft", CubeListBuilder.m_171558_().m_171514_(35, 22).m_171488_(-1.5f, 0.0f, -3.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)3.5f, (float)2.0f));
        PartDefinition legRight = body.m_171599_("legRight", CubeListBuilder.m_171558_().m_171514_(35, 22).m_171488_(-1.5f, 0.0f, -3.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)3.5f, (float)2.0f));
        PartDefinition wingLeft = body.m_171599_("wingLeft", CubeListBuilder.m_171558_().m_171514_(1, 18).m_171488_(-1.0f, -2.5f, 0.0f, 1.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.5f, (float)-1.0f, (float)-3.0f));
        PartDefinition wingRight = body.m_171599_("wingRight", CubeListBuilder.m_171558_().m_171514_(1, 18).m_171488_(0.0f, -2.5f, 0.0f, 1.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.5f, (float)-1.0f, (float)-3.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail1 = tail.m_171599_("tail1", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171488_(-5.0f, 0.0f, 0.0f, 10.0f, 0.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.5f, (float)5.0f, (float)1.4835f, (float)0.0f, (float)0.0f));
        PartDefinition tail2 = tail.m_171599_("tail2", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171488_(-5.0f, 0.0f, 0.0f, 10.0f, 0.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.5f, (float)5.0f, (float)1.4818f, (float)0.0f, (float)0.4363f));
        PartDefinition tail3 = tail.m_171599_("tail3", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171488_(-5.0f, 0.0f, 0.0f, 10.0f, 0.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.5f, (float)5.0f, (float)1.4818f, (float)0.0f, (float)-0.4363f));
        PartDefinition tail4 = tail.m_171599_("tail4", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171488_(-5.0f, 0.0f, 0.0f, 10.0f, 0.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.5f, (float)5.0f, (float)1.48f, (float)0.0f, (float)0.8727f));
        PartDefinition tail5 = tail.m_171599_("tail5", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171488_(-5.0f, 0.0f, 0.0f, 10.0f, 0.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.5f, (float)5.0f, (float)1.48f, (float)0.0f, (float)-0.8727f));
        PartDefinition tail6 = tail.m_171599_("tail6", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171488_(-5.0f, 0.0f, 0.0f, 10.0f, 0.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.5f, (float)5.0f, (float)1.4783f, (float)0.0f, (float)1.309f));
        PartDefinition tail7 = tail.m_171599_("tail7", CubeListBuilder.m_171558_().m_171514_(12, 0).m_171488_(-5.0f, 0.0f, 0.0f, 10.0f, 0.0f, 22.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.5f, (float)5.0f, (float)1.4783f, (float)0.0f, (float)-1.309f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }
}

